package ru.yandex.passport.phone.ownership;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DocumentParser {
    public static StringEntity documentToStringEntity(final Document doc) throws TransformerException,
        UnsupportedEncodingException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        DOMSource source = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        String xmlBody = writer.toString();
        return new StringEntity(xmlBody);
    }

    public static String documentToString(final Document doc) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        StringWriter sw = new StringWriter();
        t.transform(new DOMSource(doc), new StreamResult(sw));
        return sw.toString();
    }

    public static Document entityToDocument(final HttpEntity entity) throws ParserConfigurationException, IOException,
        SAXException {
        DocumentBuilder documentBuilder =
            DocumentBuilderFactory.newInstance()
                .newDocumentBuilder();
        return documentBuilder.parse(entity.getContent());
    }
}
