package ru.yandex.passport.phone.ownership;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.CodingErrorAction;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class PhoneChangeStatusPrinter extends AbstractPhoneOwnershipProxyPrinter<PhoneChangeStatusResponse> {

    protected PhoneChangeStatusPrinter(final ProxySession session) {
        super(session);
    }

    @Override
    public void completed(final PhoneChangeStatusResponse phoneChangeStatusResponse) {
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        session.connection().setSessionInfo(
            "last_change_time",
            String.valueOf(TimeUnit.MILLISECONDS.toSeconds(phoneChangeStatusResponse.lastChangeTime())));
        session.connection().setSessionInfo(
            "statusStr",
            String.valueOf(phoneChangeStatusResponse.status()));
        try (OutputStreamWriter outWriter =
                 new OutputStreamWriter(
                     out,
                     CharsetUtils.acceptedCharset(session.request())
                         .newEncoder()
                         .onMalformedInput(
                             CodingErrorAction.REPLACE)
                         .onUnmappableCharacter(
                             CodingErrorAction.REPLACE));
             JsonWriter writer = JsonTypeExtractor.NORMAL.extract(session.params()).create(outWriter)) {
            writer.startObject();
            writer.key("status");
            writer.value(phoneChangeStatusResponse.status());
            writer.key("change_date");
            writer.value(
                TimeUnit.MILLISECONDS.toSeconds(
                    phoneChangeStatusResponse.lastChangeTime()));
            writer.endObject();
        } catch (IOException | HttpException e) {
            failed(e);
        }

        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(
                    session.acceptedCharset())
                .toString());
        session.response(phoneChangeStatusResponse.status().httpStatus(), entity);
        session.logger().log(Level.INFO, "Response body: " + new String(out.toByteArray()));
    }
}
