package ru.yandex.passport.phone.ownership;

import java.io.IOException;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class PhoneChangeStatusResponse implements JsonValue {
    private final PhoneCheckStatus status;
    private final String reason;
    private final long lastChangeTime;

    public PhoneChangeStatusResponse(final PhoneCheckStatus status, final String reason) {
        this.status = status;
        this.reason = reason;
        this.lastChangeTime = 0;
    }

    public PhoneChangeStatusResponse(final PhoneCheckStatus status, final long lastChangeTime) {
        this.status = status;
        this.lastChangeTime = lastChangeTime;
        this.reason = null;
    }

    public PhoneChangeStatusResponse(final long lastChangeTime) {
        this.lastChangeTime = lastChangeTime;
        this.status = PhoneCheckStatus.OK;
        this.reason = null;
    }

    public PhoneCheckStatus status() {
        return status;
    }

    public long lastChangeTime() {
        return lastChangeTime;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.key("status");
        writer.value(status);
        if (reason != null) {
            writer.key("reason");
            writer.value(reason);
        }
        writer.key("change_date");
        writer.value(lastChangeTime);
    }
}
