package ru.yandex.passport.phone.ownership;

import java.io.IOException;
import java.util.Locale;

import org.apache.http.HttpStatus;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public enum PhoneCheckStatus implements JsonValue {
    OK,
    UNTRACKABLE,
    CHANGED,
    ALREADY_TRACKING,
    TRACKING_STARTED,
    NOT_MONITORED;

    private final String lowName;

    PhoneCheckStatus() {
        this.lowName = name().toLowerCase(Locale.ENGLISH);
    }

    public int httpStatus() {
        int status = HttpStatus.SC_INTERNAL_SERVER_ERROR;
        switch (this) {
            case OK:
            case CHANGED:
                status = HttpStatus.SC_OK;
                break;
            case UNTRACKABLE:
                status = HttpStatus.SC_UNPROCESSABLE_ENTITY;
                break;
            case ALREADY_TRACKING:
                status = HttpStatus.SC_ACCEPTED;
                break;
            case NOT_MONITORED:
                status = HttpStatus.SC_PAYMENT_REQUIRED;
                break;
        }

        return status;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.value(lowName);
    }
}
