package ru.yandex.passport.phone.ownership;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.google.i18n.phonenumbers.Phonenumber.PhoneNumber;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.searchmap.User;
import ru.yandex.passport.phone.ownership.parse.MobileOperator;
import ru.yandex.search.prefix.StringPrefix;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

public class PhoneContext implements UniversalSearchProxyRequestContext {
    private final User user;
    private final AsyncClient client;
    private final ProxySession session;
    private final Long phoneNum;
    private final String originalPhone;
    private final PhoneOwnershipProxy proxy;
    private final PhoneNumber parsedNumber;
    private final boolean skipEdna;
    private final boolean draft;
    private final boolean allowCached;
    private final MobileOperator phoneOperator;

    public PhoneContext(
        final PhoneOwnershipProxy proxy,
        final ProxySession session,
        final PhoneNumber parsedNumber,
        final String originalPhone,
        final boolean skipEdna)
        throws BadRequestException
    {
        this.originalPhone = originalPhone;
        this.parsedNumber = parsedNumber;
        this.phoneNum = PhoneOwnershipProxy.normalizePhone(originalPhone);
        this.phoneOperator = proxy.operatorMapping().find(phoneNum);
        this.user = new User(PhoneOwnershipProxy.PHONE_QUEUE_NAME, new StringPrefix(String.valueOf(phoneNum)));
        this.proxy = proxy;
        this.client = proxy.searchClient().adjust(session.context());
        this.session = session;

        boolean defaultSkipEdna = skipEdna;

        try {
            // passport-rc-s1.passport.yandex.net - example of rc host
            if (session.connection().getRemoteAddress().getHostName().startsWith("passport-rc-")) {
                defaultSkipEdna = false;
                session.logger().info("Request from rc, enabling edna flow");
            }
        } catch (Exception e) {
            session.logger().log(Level.WARNING, "Failed to resolve hostname", e);
        }

        this.skipEdna = session.params().getBoolean("skip-edna", defaultSkipEdna);

        this.draft = session.params().getBoolean("draft", true);
        this.allowCached = session.params().getBoolean("allow_cached", false);
    }

    public boolean draft() {
        return draft;
    }

    public boolean allowCached() {
        return allowCached;
    }

    public Long phone() {
        return phoneNum;
    }

    public String originalPhone() {
        return originalPhone;
    }

    public PhoneNumber parsedNumber() {
        return parsedNumber;
    }

    @Override
    public User user() {
        return user;
    }

    @Override
    public Long minPos() {
        return null;
    }

    @Override
    public long lagTolerance() {
        return 0;
    }

    @Override
    public AbstractAsyncClient<?> client() {
        return client;
    }

    @Override
    public Logger logger() {
        return session.logger();
    }

    public ProxySession session() {
        return session;
    }

    public PhoneOwnershipProxy proxy() {
        return proxy;
    }

    public boolean skipEdna() {
        return skipEdna;
    }

    public MobileOperator phoneOperator() {
        return phoneOperator;
    }
}
