package ru.yandex.passport.phone.ownership;

import java.io.IOException;
import java.util.Locale;

import com.google.i18n.phonenumbers.Phonenumber.PhoneNumber;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.passport.phone.ownership.parse.MobileOperator;

public class PhoneInfo implements JsonValue {
    private final String id;
    private final String countryName;
    private final int countryCode;
    private final Long phoneNum;
    private final String fullPhone;
    private final boolean draft;
    private final String imsi;
    private final long lastChangeTime;
    private final ChangeSource changeSource;
    private final boolean onMonitoring;
    private final MobileOperator operator;

    public PhoneInfo(
        final PhoneContext context,
        final boolean draft,
        final String imsi,
        final long lastChangeTime,
        final ChangeSource changeSource,
        final boolean onMonitoring)
    {
        this(
            context.parsedNumber().getCountryCodeSource().name(),
            context.parsedNumber().getCountryCode(),
            context.phone(),
            context.originalPhone(),
            context.phoneOperator(),
            draft,
            imsi,
            lastChangeTime,
            changeSource,
            onMonitoring);
    }

    public PhoneInfo(
        final PhoneNumber parsedNumber,
        final Long phoneNum,
        final String fullPhone,
        final MobileOperator operator,
        final boolean draft,
        final String imsi,
        final long lastChangeTime,
        final ChangeSource changeSource,
        final boolean onMonitoring)
    {
        this(
            parsedNumber.getCountryCodeSource().name(),
            parsedNumber.getCountryCode(),
            phoneNum,
            fullPhone,
            operator,
            draft,
            imsi,
            lastChangeTime,
            changeSource,
            onMonitoring);
    }

    public PhoneInfo(
        final String countryName,
        final int countryCode,
        final Long phoneNum,
        final String fullPhone,
        final MobileOperator operator,
        final boolean draft,
        final String imsi,
        final long lastChangeTime,
        final ChangeSource changeSource,
        final boolean onMonitoring)
    {
        this.id = PhoneOwnershipProxy.phoneId(phoneNum);
        this.countryName = countryName;
        this.countryCode = countryCode;
        this.phoneNum = phoneNum;
        this.fullPhone = fullPhone;
        this.draft = draft;
        this.imsi = imsi;
        this.lastChangeTime = lastChangeTime;
        this.changeSource = changeSource;
        this.onMonitoring = onMonitoring;
        this.operator = operator;
    }

    public String countryName() {
        return countryName;
    }

    public int countryCode() {
        return countryCode;
    }

    public Long phoneNum() {
        return phoneNum;
    }

    /**
     * e164 phone format +79261234567
     *
     * @return
     */
    public String fullPhone() {
        return fullPhone;
    }

    public boolean draft() {
        return draft;
    }

    public String imsi() {
        return imsi;
    }

    public long lastChangeTime() {
        return lastChangeTime;
    }

    public ChangeSource changeSource() {
        return changeSource;
    }

    public boolean onMonitoring() {
        return onMonitoring;
    }

    @Override
    public String toString() {
        return "PhoneInfo{" +
            "phone='" + phoneNum + '\'' +
            ", draft=" + draft +
            ", imsi='" + imsi + '\'' +
            ", lastChangeTime=" + lastChangeTime +
            '}';
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("id");
        writer.value(id);
        writer.key("phone");
        writer.value(fullPhone());
        writer.key("country_name");
        writer.value(countryName());
        writer.key("country_code");
        writer.value(countryCode());
        if (operator != null) {
            writer.key("opsos_region");
            writer.value(operator.region());
            writer.key("opsos_name_keyword");
            writer.value(operator.name());
            writer.key("opsos_name_normalized");
            writer.value(operator.normalized());
        } else {
            writer.key("opsos_name_normalized");
            writer.value("unknown_operator");
            writer.key("opsos_name_keyword");
            writer.value("unknown_operator");
        }

        writer.key("imsi");
        writer.value(imsi());
        writer.key("draft");
        writer.value(draft());
        writer.key("imsi_change_time");
        writer.value(lastChangeTime());
        writer.key("last_change_source");
        writer.value(changeSource().name().toLowerCase(Locale.ENGLISH));
        writer.key("on_monitoring");
        writer.value(onMonitoring());
        writer.endObject();
    }
}
