package ru.yandex.passport.phone.ownership;

import java.io.IOException;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;

public class PhoneStartTrackingHandler implements ProxyRequestHandler {
    private final PhoneStartTrackingDraftTrueHandler phoneStartTrackingDraftTrueHandler;
    private final PhoneStartTrackingDraftFalseHandler phoneStartTrackingDraftFalseHandler;

    public PhoneStartTrackingHandler(final PhoneOwnershipProxy proxy) {
        this.phoneStartTrackingDraftTrueHandler = new PhoneStartTrackingDraftTrueHandler(proxy);
        this.phoneStartTrackingDraftFalseHandler = new PhoneStartTrackingDraftFalseHandler(proxy);
    }

    @Override
    public void handle(final ProxySession session) throws HttpException, IOException {
        boolean draft = session.params().getBoolean("draft", false);
        if (draft) {
            phoneStartTrackingDraftTrueHandler.handle(session);
        } else {
            phoneStartTrackingDraftFalseHandler.handle(session);
        }
    }
}
