package ru.yandex.passport.phone.ownership;

import java.io.IOException;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class PhoneStatusResponse implements JsonValue {
    private final PhoneCheckStatus status;
    private final String reason;

    public PhoneStatusResponse(final PhoneCheckStatus status) {
        this.status = status;
        this.reason = null;
    }

    public PhoneStatusResponse(final PhoneCheckStatus status, final String reason) {
        this.status = status;
        this.reason = reason;
    }

    public PhoneCheckStatus status() {
        return status;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.key("status");
        writer.value(status);
        if (reason != null) {
            writer.key("reason");
            writer.value(reason);
        }
    }
}
