package ru.yandex.passport.phone.ownership;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.CodingErrorAction;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class PhoneStatusResponsePrinter
    extends AbstractPhoneOwnershipProxyPrinter<PhoneStatusResponse> {

    protected PhoneStatusResponsePrinter(final ProxySession session) {
        super(session);
    }

    @Override
    public void completed(final PhoneStatusResponse phoneStatusResponse) {
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        session.connection().setSessionInfo(
            "statusStr",
            String.valueOf(phoneStatusResponse.status()));
        try (OutputStreamWriter outWriter =
                 new OutputStreamWriter(
                     out,
                     CharsetUtils.acceptedCharset(session.request())
                         .newEncoder()
                         .onMalformedInput(
                             CodingErrorAction.REPLACE)
                         .onUnmappableCharacter(
                             CodingErrorAction.REPLACE));
             JsonWriter writer = JsonTypeExtractor.NORMAL.extract(session.params()).create(outWriter)) {
            writer.startObject();
            writer.key("status");
            writer.value(phoneStatusResponse.status());
            writer.endObject();
        } catch (IOException | HttpException e) {
            failed(e);
        }

        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(
                    session.acceptedCharset())
                .toString());
        session.response((phoneStatusResponse.status().httpStatus()), entity);
        session.logger().log(Level.INFO, "Response body: " + new String(out.toByteArray()));
    }
}
