package ru.yandex.passport.phone.ownership;

import java.io.IOException;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.client.producer.ProducerClient;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.BasicAsyncResponseConsumerFactory;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.QueryConstructor;

public class StorageRequestUtils {
    private static final long FAILOVER_DELAY = 100;

    public static void searchRequest(
        final PhoneContext context,
        final PhoneOwnershipProxy proxy,
        final FutureCallback<JsonObject> callback)
        throws BadRequestException {
        QueryConstructor qc = new QueryConstructor("/search?phoneOwnership");
        qc.append("prefix", context.user().prefix().toString());
        qc.append("text", "id:" + PhoneOwnershipProxy.phoneId(context.phone()));
        qc.append("get", "*");

        context.logger().info("Starting sequentual");
        proxy.sequentialRequest(
            context.session(),
            context,
            new BasicAsyncRequestProducerGenerator(qc.toString()),
            FAILOVER_DELAY,
            true,
            JsonAsyncTypesafeDomConsumerFactory.OK,
            context.session().listener().createContextGeneratorFor(context.client()),
            callback);
    }

    public static void modifyPhoneInStorage(
        final PhoneContext context,
        final PhoneInfo phoneInfo,
        final PhoneOwnershipProxy proxy,
        final FutureCallback<Object> callback)
        throws BadRequestException, IOException {
        makeAndProcessIndexRequestToStorage(context, phoneInfo.phoneNum(), phoneInfo, proxy, callback, "/modify" +
            "?phoneOwnership");
    }

    public static void addPhoneToStorage(
        final PhoneContext context,
        final PhoneInfo phoneInfo,
        final PhoneOwnershipProxy proxy,
        final FutureCallback<Object> callback)
        throws BadRequestException, IOException {
        makeAndProcessIndexRequestToStorage(context, phoneInfo.phoneNum(), phoneInfo, proxy, callback, "/add" +
            "?phoneOwnership");
    }

    public static void updatePhoneFieldsInStorage(
        final PhoneContext context,
        final long phoneNum,
        final Map<String, Object> fieldsToUpdate,
        final PhoneOwnershipProxy proxy,
        final FutureCallback<Object> callback) throws BadRequestException,
        IOException {

        updatePhoneInStorage(context, phoneNum, writer -> {
            writer.startObject();
            writer.key("id");
            writer.value(PhoneOwnershipProxy.phoneId(phoneNum));
            for (Map.Entry<String, Object> entry : fieldsToUpdate.entrySet()) {
                writer.key(entry.getKey());
                writer.value(entry.getValue());
            }
            writer.endObject();
        }, proxy, callback);
    }


    public static void updatePhoneInStorage(
        final PhoneContext context,
        final long phoneNum,
        final JsonValue docsUpdate,
        final PhoneOwnershipProxy proxy,
        final FutureCallback<Object> callback) throws BadRequestException, IOException {
        makeAndProcessIndexRequestToStorage(context, phoneNum, docsUpdate, proxy, callback, "/update?phoneOwnership");

    }

    private static void makeAndProcessIndexRequestToStorage(
        final PhoneContext context,
        final Long phoneNum,
        final JsonValue docs,
        final PhoneOwnershipProxy proxy,
        final FutureCallback<Object> callback,
        String uri)
        throws BadRequestException, IOException {
        QueryConstructor qc = new QueryConstructor(uri);
        qc.append("service", context.user().service());
        qc.append("prefix", context.user().prefix().toString());
        StringBuilderWriter postSbw = new StringBuilderWriter();
        try (JsonWriter writer = JsonType.NORMAL.create(postSbw)) {
            writer.startObject();
            writer.key("prefix");
            writer.value(phoneNum);
            writer.key("docs");
            writer.startArray();
            writer.value(docs);
            writer.endArray();
            writer.endObject();

            ProducerClient client = proxy.producerClient().adjust(context.session().context());
            String s = postSbw.toString();
            client.execute(
                proxy.producerHost(),
                new BasicAsyncRequestProducerGenerator(qc.toString(), s),
                BasicAsyncResponseConsumerFactory.INSTANCE,
                context.session().listener().createContextGeneratorFor(client),
                callback);
        }
    }

    public static PhoneInfo parseSearchResult(final JsonObject searchResult, final PhoneContext context) throws JsonException {
        PhoneInfo phoneInfo = null;
        JsonMap searchResultMap = searchResult.asMap();
        JsonList hitsArray = searchResultMap.getList("hitsArray");
        context.session().logger().info("hitsCount: " + hitsArray.size());
        if (hitsArray.size() > 0) {
            JsonMap firstResult = hitsArray.get(0).asMap();
            String imsi = firstResult.getString("imsi", null);
            boolean draft = firstResult.getBoolean("draft", false);
            Long lastChangeTime = firstResult.getLong("imsi_change_time", null);
            ChangeSource changeSource =
                firstResult.getEnum(ChangeSource.class, "last_change_source", ChangeSource.UNKNOWN);
            Boolean onMonitoring = firstResult.getBoolean("on_monitoring", false);
            phoneInfo = new PhoneInfo(
                context,
                draft,
                imsi,
                lastChangeTime,
                changeSource,
                onMonitoring);
        }
        return phoneInfo;
    }
}
