package ru.yandex.passport.phone.ownership;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.passport.phone.ownership.parse.PhoneParseResult;
import ru.yandex.passport.phone.ownership.parse.PhoneParseStatus;
import ru.yandex.passport.phone.ownership.parse.PhoneParser;

public class UpdatePhoneStatusHandler implements ProxyRequestHandler {
    private final PhoneOwnershipProxy proxy;

    public UpdatePhoneStatusHandler(final PhoneOwnershipProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void handle(final ProxySession session) throws HttpException, IOException {
        String phoneStr = session.params().getString("phone");
        long ts = session.params().getLong("ts");
        boolean modify = session.params().getBoolean("modify", false);

        PhoneParseResult parseResult;
        try {
            parseResult = PhoneParser.RUSSIA.parse(session.logger(), phoneStr);

            if (parseResult.status() != PhoneParseStatus.OK) {
                session.response(HttpStatus.SC_UNPROCESSABLE_ENTITY);
                return;
            }
        } catch (Exception bre) {
            throw new BadRequestException(bre);
        }

        PhoneContext context =
            new PhoneContext(proxy, session, parseResult.phone(), phoneStr, true);
        if (modify) {
            StorageRequestUtils.modifyPhoneInStorage(
                context,
                new PhoneInfo(
                    context,
                    false,
                    null,
                    ts,
                    ChangeSource.MANUAL,
                    false),
                proxy,
                new PrintCallback(session));
        } else {
            StorageRequestUtils.addPhoneToStorage(
                context,
                new PhoneInfo(
                    context,
                    false,
                    null,
                    ts,
                    ChangeSource.MANUAL,
                    false),
                proxy,
                new PrintCallback(session));
        }
    }

    private static class PrintCallback extends AbstractProxySessionCallback<Object> {
        public PrintCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Object o) {
            session.response(HttpStatus.SC_OK);
        }
    }
}
