package ru.yandex.passport.phone.ownership.config;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractEdnaConfigBuilder
    <T extends AbstractEdnaConfigBuilder<T>>
    extends AbstractHttpHostConfigBuilder<T>
    implements EdnaConfig {
    private static final String LOGIN = "login";
    private static final String PASSWORD = "password";
    private String login;
    private String password;

    protected AbstractEdnaConfigBuilder(final EdnaConfig config) {
        super(config);
        this.login = config.login();
        this.password = config.password();
    }

    protected AbstractEdnaConfigBuilder(
        final IniConfig config,
        final EdnaConfig defaults)
        throws ConfigException {
        super(config, defaults);
        login = config.getString(LOGIN, defaults.login());
        password = config.getString(PASSWORD, defaults.password());
    }

    @Override
    public String login() {
        return login;
    }

    @Override
    public String password() {
        return password;
    }
}
