package ru.yandex.passport.phone.ownership.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public abstract class AbstractPhoneOwnershipProxyConfigBuilder
    <T extends AbstractPhoneOwnershipProxyConfigBuilder<T>>
    extends AbstractUniversalSearchProxyConfigBuilder<T>
    implements PhoneOwnershipProxyConfig {
    private EdnaConfigBuilder ednaConfig;
    private EdnaConfigBuilder fromEdnaConfig;

    protected AbstractPhoneOwnershipProxyConfigBuilder(final PhoneOwnershipProxyConfig config) {
        super(config);
        ednaConfig(config.ednaConfig());
    }

    protected AbstractPhoneOwnershipProxyConfigBuilder(
        final IniConfig config,
        final PhoneOwnershipProxyConfig defaults)
        throws ConfigException {
        super(config, defaults);

        IniConfig ednaConfigSection = config.sectionOrNull("edna");
        if (ednaConfigSection != null) {
            this.ednaConfig = new EdnaConfigBuilder(ednaConfigSection, defaults.ednaConfig());
        } else {
            this.ednaConfig = new EdnaConfigBuilder(defaults.ednaConfig());
        }
    }

    @Override
    public EdnaConfigBuilder ednaConfig() {
        return ednaConfig;
    }

    public T ednaConfig(final EdnaConfig config) {
        this.ednaConfig = new EdnaConfigBuilder(config);
        return self();
    }
}
