package ru.yandex.passport.phone.ownership.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class EdnaConfigBuilder
    extends AbstractEdnaConfigBuilder<EdnaConfigBuilder> {
    public EdnaConfigBuilder() {
        this(EdnaConfigDefaults.INSTANCE);
    }

    public EdnaConfigBuilder(final EdnaConfig config) {
        super(config);
    }

    public EdnaConfigBuilder(
        final IniConfig config)
        throws ConfigException {
        this(config, EdnaConfigDefaults.INSTANCE);
    }

    public EdnaConfigBuilder(
        final IniConfig config,
        final EdnaConfig defaults)
        throws ConfigException {
        super(config, defaults);
    }

    public ImmutableEdnaConfig build() throws ConfigException {
        return new ImmutableEdnaConfig(
            this);
    }

    @Override
    public EdnaConfigBuilder self() {
        return this;
    }
}
