package ru.yandex.passport.phone.ownership.config;

import org.apache.http.HttpHost;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableEdnaConfig
    extends ImmutableHttpTargetConfig implements EdnaConfig {
    private final HttpHost host;
    private final String login;
    private final String password;

    public ImmutableEdnaConfig(
        final EdnaConfig config)
        throws ConfigException {
        super(config);

        if (config.host() == null) {
            throw new ConfigException("Host is not specified");
        }
        this.host = config.host();
        this.login = config.login();
        this.password = config.password();
    }

    @Override
    public HttpHost host() {
        return host;
    }

    @Override
    public String login() {
        return login;
    }

    @Override
    public String password() {
        return password;
    }
}
