package ru.yandex.passport.phone.ownership.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutablePhoneOwnershipProxyConfig extends ImmutableUniversalSearchProxyConfig
    implements PhoneOwnershipProxyConfig {
    private final ImmutableEdnaConfig ednaConfig;

    public ImmutablePhoneOwnershipProxyConfig(PhoneOwnershipProxyConfig config) throws ConfigException {
        super(config);
        this.ednaConfig = new ImmutableEdnaConfig(config.ednaConfig());
    }

    @Override
    public ImmutableEdnaConfig ednaConfig() {
        return ednaConfig;
    }
}
