package ru.yandex.passport.phone.ownership.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class PhoneOwnershipProxyConfigBuilder
    extends AbstractPhoneOwnershipProxyConfigBuilder<PhoneOwnershipProxyConfigBuilder> {
    public PhoneOwnershipProxyConfigBuilder() {
        this(PhoneOwnershipProxyConfigDefaults.INSTANCE);
    }

    public PhoneOwnershipProxyConfigBuilder(final PhoneOwnershipProxyConfig config) {
        super(config);
    }

    public PhoneOwnershipProxyConfigBuilder(
        final IniConfig config)
        throws ConfigException {
        this(config, PhoneOwnershipProxyConfigDefaults.INSTANCE);
    }

    public PhoneOwnershipProxyConfigBuilder(
        final IniConfig config,
        final PhoneOwnershipProxyConfig defaults)
        throws ConfigException {
        super(config, defaults);
    }

    public ImmutablePhoneOwnershipProxyConfig build() throws ConfigException {
        return new ImmutablePhoneOwnershipProxyConfig(
            this);
    }

    @Override
    public PhoneOwnershipProxyConfigBuilder self() {
        return this;
    }
}
