package ru.yandex.passport.phone.ownership.edna;

import java.io.StringReader;
import java.text.ParseException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.http.protocol.HttpContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import ru.yandex.function.CharArrayProcessable;
import ru.yandex.http.util.nio.AbstractAsyncCharArrayConsumer;

public class EdnaImsiResponseConsumer extends AbstractAsyncCharArrayConsumer<ImsiResponse> {
    public EdnaImsiResponseConsumer() {
    }

    @Override
    protected ImsiResponse buildResult(
        final CharArrayProcessable data,
        final HttpContext context)
        throws Exception
    {
        DocumentBuilder documentBuilder =
            DocumentBuilderFactory.newInstance()
                .newDocumentBuilder();
        Document responseDoc = documentBuilder.parse(new InputSource(new StringReader(data.toString())));
        Node payloadNode = responseDoc.getElementsByTagName("payload").item(0);
        if (payloadNode.getNodeType() != Node.ELEMENT_NODE) {
            throw new ParseException("Expecting payload node but got " + payloadNode.getNodeType(), 0);
        }

        String code = ((Element) payloadNode).getElementsByTagName("code").item(0).getTextContent();
        if (!"ok".equalsIgnoreCase(code)) {
            return new ImsiResponse(null, code, null);
        }

        Node subscriberAddressNode = responseDoc.getElementsByTagName("subscriberAddress").item(0);

        if (subscriberAddressNode.getNodeType() != Node.ELEMENT_NODE) {
            throw new ParseException("Expecting subscriberAddress node but got " + subscriberAddressNode.getNodeType(), 0);
        }

        Element subscriberAddress = (Element) subscriberAddressNode;
        NodeList subsCodeNode = subscriberAddress.getElementsByTagName("code");
        if (subsCodeNode == null || subsCodeNode.getLength() != 1) {
            throw new ParseException("No subscription code node found", 0);
        }

        String subsCode = subsCodeNode.item(0).getTextContent();
        if ("ok".equalsIgnoreCase(subsCode)) {
            NodeList imsiSubsNode = subscriberAddress.getElementsByTagName("subscriberImsi");
            if (imsiSubsNode == null
                    || imsiSubsNode.getLength() != 1
                    || imsiSubsNode.item(0).getNodeType() != Node.ELEMENT_NODE)
            {
                throw new ParseException("No subscriberImsi node  found", 0);
            }

            Element imsiSubsEl = (Element) imsiSubsNode.item(0);

            NodeList imsiNode = imsiSubsEl.getElementsByTagName("imsi");
            if (imsiNode == null
                    || imsiNode.getLength() != 1)
            {
                throw new ParseException("No subscriberImsi node  found", 0);
            }

            String imsi = imsiNode.item(0).getTextContent();
            return new ImsiResponse(imsi, code, subsCode);
        } else {
            return new ImsiResponse(null, code, subsCode);
        }
    }
}
