package ru.yandex.passport.phone.ownership.edna;

import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public class EdnaImsiResponseConsumerFactory implements HttpAsyncResponseConsumerFactory<ImsiResponse> {
    public static final HttpAsyncResponseConsumerFactory<ImsiResponse> OK
        = new StatusCheckAsyncResponseConsumerFactory<>(
        HttpStatusPredicates.OK,
        new EdnaImsiResponseConsumerFactory());

    @Override
    public HttpAsyncResponseConsumer<ImsiResponse> create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response) {
        return new EdnaImsiResponseConsumer();
    }
}
