package ru.yandex.passport.phone.ownership.edna;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EdnaRequestConstructor {
    public static Document constructSubscriberAddressListRequest(Long phone, String loginValue, String passwordValue,
                                                                 String request) throws ParserConfigurationException {
        DocumentBuilder documentBuilder =
            DocumentBuilderFactory.newInstance()
                .newDocumentBuilder();
        Document doc = documentBuilder.newDocument();
        Element rootElement = doc.createElement(request);
        Element header = doc.createElement("header");
        Element login = doc.createElement("login");
        login.setTextContent(loginValue);

        Element password = doc.createElement("password");
        password.setTextContent(passwordValue);

        header.appendChild(login);
        header.appendChild(password);

        Element payload = doc.createElement("payload");
        Element subscriberAddressList = doc.createElement("subscriberAddressList");
        Element address = doc.createElement("address");
        address.setTextContent(String.valueOf(phone));
        subscriberAddressList.appendChild(address);
        payload.appendChild(subscriberAddressList);
        rootElement.appendChild(header);
        rootElement.appendChild(payload);
        doc.appendChild(rootElement);
        return doc;
    }
}
