package ru.yandex.passport.phone.ownership.edna;

import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.passport.phone.ownership.DocumentParser;
import ru.yandex.passport.phone.ownership.PhoneContext;
import ru.yandex.passport.phone.ownership.PhoneOwnershipProxy;

public class EdnaRequestUtils {
    public static Document constructSubscriberAddressListRequest(
        final long phone,
        final String loginValue,
        final String passwordValue,
        final String request) throws ParserConfigurationException {
        DocumentBuilder documentBuilder =
            DocumentBuilderFactory.newInstance()
                .newDocumentBuilder();
        Document doc = documentBuilder.newDocument();
        Element rootElement = doc.createElement(request);
        Element header = doc.createElement("header");
        Element auth = doc.createElement("auth");
        Element login = doc.createElement("login");
        login.setTextContent(loginValue);

        Element password = doc.createElement("password");
        password.setTextContent(passwordValue);

        auth.appendChild(login);
        auth.appendChild(password);
        header.appendChild(auth);
        Element payload = doc.createElement("payload");
        Element subscriberAddressList = doc.createElement("subscriberAddressList");
        Element subscriberAddress = doc.createElement("subscriberAddress");
        Element address = doc.createElement("address");
        address.setTextContent(String.valueOf(phone));
        subscriberAddress.appendChild(address);
        subscriberAddressList.appendChild(subscriberAddress);
        payload.appendChild(subscriberAddressList);
        rootElement.appendChild(header);
        rootElement.appendChild(payload);
        doc.appendChild(rootElement);
        return doc;
    }

    public static void sendImsiRequest(
        final PhoneOwnershipProxy proxy,
        final ProxySession session,
        final long phone,
        final FutureCallback<ImsiResponse> callback)
    {
        QueryConstructor qc = new QueryConstructor("/edna/imsi?");
        qc.append("phone", phone);
        String login = proxy.config().ednaConfig().login();
        String password = proxy.config().ednaConfig().password();

        try {
            Document doc = constructSubscriberAddressListRequest(phone, login, password,
                "provideSubscriberImsiRequest");
            StringEntity entity = DocumentParser.documentToStringEntity(doc);
            AsyncClient ednaClient = proxy.ednaClient().adjust(session.context());
            ednaClient.execute(
                proxy.config().ednaConfig().host(),
                new BasicAsyncRequestProducerGenerator(qc.toString(), entity),
                EdnaImsiResponseConsumerFactory.OK,
                session.listener().adjustContextGenerator(
                    ednaClient.httpClientContextGenerator()),
                callback);
        } catch (IOException | ParserConfigurationException | TransformerException e) {
            callback.failed(e);
            return;
        }
    }

    public static void sendImsiRequest(
        final PhoneOwnershipProxy proxy,
        final PhoneContext context,
        final ProcessImsiResponseCallback callback)
        throws ParserConfigurationException, IOException, TransformerException
    {
        sendImsiRequest(proxy, context.session(), context.phone(), callback);
    }
}
