package ru.yandex.passport.phone.ownership.edna;

import java.io.StringReader;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.http.protocol.HttpContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import ru.yandex.function.CharArrayProcessable;
import ru.yandex.http.util.nio.AbstractAsyncCharArrayConsumer;

public class EdnaUnsubscribeResponseConsumer extends AbstractAsyncCharArrayConsumer<UnsubscribeResponse> {
    public EdnaUnsubscribeResponseConsumer() {
    }

    @Override
    protected UnsubscribeResponse buildResult(
        final CharArrayProcessable data,
        final HttpContext context)
        throws Exception {
        DocumentBuilder documentBuilder =
            DocumentBuilderFactory.newInstance()
                .newDocumentBuilder();
        Document responseDoc = documentBuilder.parse(new InputSource(new StringReader(data.toString())));
        Node payload = responseDoc.getElementsByTagName("payload").item(0);
        String code = payload.getFirstChild().getTextContent();

        Node subscriberAddress = responseDoc.getElementsByTagName("subscriberAddress").item(0);
        NodeList subscriberAttributes = subscriberAddress.getChildNodes();

        String subscriberCode = subscriberAttributes.item(1).getTextContent();

        return new UnsubscribeResponse(code, subscriberCode);
    }
}
