package ru.yandex.passport.phone.ownership.edna;

import java.io.IOException;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.EmptyFutureCallback;
import ru.yandex.passport.phone.ownership.ChangeSource;
import ru.yandex.passport.phone.ownership.PhoneChangeStatusResponse;
import ru.yandex.passport.phone.ownership.PhoneCheckStatus;
import ru.yandex.passport.phone.ownership.PhoneContext;
import ru.yandex.passport.phone.ownership.PhoneInfo;
import ru.yandex.passport.phone.ownership.StorageRequestUtils;

public final class ProcessImsiResponseCallback
    extends AbstractFilterFutureCallback<ImsiResponse, PhoneChangeStatusResponse> {
    private final PhoneInfo phoneInfo;
    private final PhoneContext context;

    public ProcessImsiResponseCallback(
        final PhoneContext context,
        final PhoneInfo phoneInfo,
        final FutureCallback<? super PhoneChangeStatusResponse> callback) {
        super(callback);
        this.context = context;
        this.phoneInfo = phoneInfo;
    }


    @Override
    public void completed(final ImsiResponse imsiResponse) {
        try {
            if (!(imsiResponse.code().equals(AddressRequestStatus.OK) &&
                imsiResponse.subscriberCode().equals(AddressRequestStatus.OK))) {
                context.logger().info("Edna error " + imsiResponse);
                failed(new BadRequestException("Can't get info of subsriber"));
                return;
            }
            context.session().logger().info("Edna response " + imsiResponse);
            if (phoneInfo == null) {
                StorageRequestUtils.addPhoneToStorage(
                    context,
                    new PhoneInfo(
                        context,
                        true,
                        imsiResponse.imsi(),
                        0,
                        ChangeSource.ID_CREATE,
                        true),
                    context.proxy(),
                    EmptyFutureCallback.INSTANCE);
                callback.completed(new PhoneChangeStatusResponse(PhoneCheckStatus.OK, 0));
            } else if (!imsiResponse.imsi().equals(phoneInfo.imsi())) {
                long timeChanged = System.currentTimeMillis();
                StorageRequestUtils.modifyPhoneInStorage(
                    context,
                    new PhoneInfo(
                        context, phoneInfo.draft(), imsiResponse.imsi(),
                        timeChanged,
                        ChangeSource.ID_EDNA_CHANGE,
                        true),
                    context.proxy(),
                    EmptyFutureCallback.INSTANCE);
                callback.completed(new PhoneChangeStatusResponse(PhoneCheckStatus.CHANGED, timeChanged));
            } else {
                callback.completed(new PhoneChangeStatusResponse(PhoneCheckStatus.OK, phoneInfo.lastChangeTime()));
            }
        } catch (BadRequestException | IOException e) {
            failed(e);
        }
    }

    @Override
    public void failed(Exception e) {
        callback.failed(e);
    }

    @Override
    public void cancelled() {
        callback.cancelled();
    }
}

