package ru.yandex.passport.phone.ownership.parse;

import java.util.Locale;

public class MobileOperator {
    private final long left;
    private final long right;
    private final String name;
    private final String normalized;
    private final String region;

    public MobileOperator(final long left, final long right, final String name, final String region) {
        this.left = left;
        this.right = right;
        this.name = name;
        this.region = region;
        String normalized = name.toLowerCase(
            new Locale("ru", "RU"))
            .trim();
        normalized = normalized
            .replaceAll("^(пао|ао|ооо|оао|зао|фгуп|акционерное общество)", "");
        normalized = normalized.replaceAll("[^\\s\\p{L}\\p{N}]+", "").trim();
        this.normalized = normalized;
    }

    public long left() {
        return left;
    }

    public long right() {
        return right;
    }

    public String name() {
        return name;
    }

    public String region() {
        return region;
    }

    public String normalized() {
        return normalized;
    }
}
