package ru.yandex.passport.phone.ownership.parse;

import com.google.i18n.phonenumbers.Phonenumber.PhoneNumber;

public class PhoneParseResult {
    private final PhoneNumber phone;
    private final PhoneParseStatus status;
    private final String reason;

    public PhoneParseResult(final PhoneNumber phone) {
        this.phone = phone;
        this.status = PhoneParseStatus.OK;
        this.reason = null;
    }

    public PhoneParseResult(final PhoneParseStatus status, final String reason) {
        this.status = status;
        this.reason = reason;
        this.phone = null;
    }

    public PhoneParseResult(final PhoneNumber phone, final PhoneParseStatus status, final String reason) {
        this.phone = phone;
        this.status = status;
        this.reason = reason;
    }

    public PhoneNumber phone() {
        return phone;
    }

    public PhoneParseStatus status() {
        return status;
    }

    public String reason() {
        return reason;
    }
}
