package ru.yandex.passport.phone.ownership.parse;

import java.util.logging.Level;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber.PhoneNumber;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.passport.phone.ownership.PhoneChangeStatusPrinter;
import ru.yandex.passport.phone.ownership.PhoneChangeStatusResponse;
import ru.yandex.passport.phone.ownership.PhoneCheckStatus;

public enum PhoneParser {
    RUSSIA("RU");

    private final String country;

    PhoneParser(final String country) {
        this.country = country;
    }

    public PhoneParseResult parse(final PrefixedLogger logger, final String phoneStr) throws Exception {
        try {
            PhoneNumber phone = PhoneNumberUtil.getInstance().parse(phoneStr, country);
            if (!PhoneNumberUtil.getInstance().isValidNumberForRegion(phone, country)) {
                return new PhoneParseResult(
                    phone,
                    PhoneParseStatus.NOT_VALID_FOR_REGION,
                    "phone not valid for " + country);
            }

            return new PhoneParseResult(phone);
        } catch (Exception e) {
            if (logger != null) {
                logger.log(Level.WARNING, "Failed to parse number " + phoneStr, e);
            }
            return new PhoneParseResult(PhoneParseStatus.PARSE_FAILED, e.getMessage());
        }
    }

    public static void completePhoneChangeStatusParseFailureResponse(
        final PhoneParseResult parseResult,
        final String phoneStr,
        final PhoneChangeStatusPrinter callback) {
        switch (parseResult.status()) {
            case PARSE_FAILED:
                callback.completed(
                    new PhoneChangeStatusResponse(
                        PhoneCheckStatus.UNTRACKABLE,
                        "Failed to parse phone " + parseResult.reason()));
            case NOT_VALID_FOR_REGION:
                //https://st.yandex-team.ru/PASSP-37610
                if (parseResult.phone().getCountryCode() == 7 && phoneStr.startsWith("+7000")) {
                    callback.completed(
                        new PhoneChangeStatusResponse(
                            PhoneCheckStatus.OK, 0));
                    return;
                }
                callback.completed(
                    new PhoneChangeStatusResponse(
                        PhoneCheckStatus.UNTRACKABLE,
                        "Region not supported"));
        }
    }
}
