package ru.yandex.search.shakur;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public abstract class AbstractShakurConfigBuilder
    <T extends AbstractShakurConfigBuilder<T>>
    extends AbstractUniversalSearchProxyConfigBuilder<T>
    implements ShakurConfig
{
    private String shakurService;
    private int passportMinFreq;

    public AbstractShakurConfigBuilder(
        final ShakurConfig config)
        throws ConfigException
    {
        super(config);
        this.shakurService = config.shakurService();
    }

    public AbstractShakurConfigBuilder(
        final IniConfig config,
        final ShakurConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.shakurService = config.getString(
            "shakur-service",
            defaults.shakurService());
        this.passportMinFreq = config.getInt(
            "passport-min-pwd-freq",
            defaults.passportMinFreq());
    }

    public void copyTo(final AbstractShakurConfigBuilder<?> other) {
        copyTo((AbstractUniversalSearchProxyConfigBuilder<?>) other);
    }

    @Override
    public String shakurService() {
        return shakurService;
    }

    public T shakurService(final String shakurService) {
        this.shakurService = shakurService;
        return self();
    }

    @Override
    public int passportMinFreq() {
        return passportMinFreq;
    }

    public T passportMinFreq(final int passportMinFreq) {
        this.passportMinFreq = passportMinFreq;
        return self();
    }
}
