package ru.yandex.search.shakur;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableShakurConfig
    extends ImmutableUniversalSearchProxyConfig
    implements ShakurConfig
{
    private final String shakurService;
    private final int passportMinFreq;

    public ImmutableShakurConfig(
        final ShakurConfig config)
        throws ConfigException
    {
        super(config);
        this.shakurService = config.shakurService();
        this.passportMinFreq = config.passportMinFreq();
    }

    @Override
    public String shakurService() {
        return shakurService;
    }

    @Override
    public int passportMinFreq() {
        return passportMinFreq;
    }
}
