package ru.yandex.search.shakur;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;

import ru.yandex.collection.Pattern;
import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.proxy.universal.UniversalSearchProxy;
import ru.yandex.stater.CountAggregatorFactory;
import ru.yandex.stater.DuplexStaterFactory;
import ru.yandex.stater.NamedStatsAggregatorFactory;
import ru.yandex.stater.PassiveStaterAdapter;
import ru.yandex.stater.RequestInfo;
import ru.yandex.stater.RequestTimeHistogramMetric;
import ru.yandex.stater.RequestsStater;

//import ru.yandex.http.util.request.RequestHandlerMapper;

public class Shakur extends UniversalSearchProxy<ImmutableShakurConfig> {
    private final TimeFrameQueue<Object> passportChecks;
    private final TimeFrameQueue<Object> passportMatches;
    private final TimeFrameQueue<Object> passportSkipped;
    private final RequestsStater passportFreqStater;

    public Shakur(final ImmutableShakurConfig config)
        throws IOException, ConfigException
    {
        super(config);
        register(
            new Pattern<>("/api/shakur/checkpassword", false),
            new CheckPasswordHandler(this),
            RequestHandlerMapper.GET,
            RequestHandlerMapper.POST);

        passportChecks = new TimeFrameQueue<>(config.metricsTimeFrame());
        passportMatches = new TimeFrameQueue<>(config.metricsTimeFrame());
        passportSkipped = new TimeFrameQueue<>(config.metricsTimeFrame());
        RequestTimeHistogramMetric passportFreqBuilder =
            new RequestTimeHistogramMetric(
                new IniConfig(
                    new StringReader(
                        "histogram-ranges = 0, 1, 2, 4, 8, 16, 24, 32, 48, "
                        + "56, 64, 100, 200, 400, 800, "
                        + "1000, 2000, 4000, 8000, 10000, 20000, "
                        + "40000, 60000, 80000, 100000, 120000\n"
                        + "precise-histogram = true\n"
                        + "processing-time-stats = false")));

        passportFreqStater =
            new RequestsStater(
                config.metricsTimeFrame(),
                "passport-freq-hist",
                Collections.singletonList(passportFreqBuilder),
                "freq",
                "Passport pwd freqs");
        registerStater(passportFreqStater);


        registerStater(
            new PassiveStaterAdapter<>(
                passportChecks,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "passport_checks_ammm",
                        CountAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "passport_checks_axxx",
                        CountAggregatorFactory.INSTANCE))));
        registerStater(
            new PassiveStaterAdapter<>(
                passportMatches,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "passport_matches_ammm",
                        CountAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "passport_matches_axxx",
                        CountAggregatorFactory.INSTANCE))));
        registerStater(
            new PassiveStaterAdapter<>(
                passportSkipped,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "passport_skipped_ammm",
                        CountAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "passport_skipped_axxx",
                        CountAggregatorFactory.INSTANCE))));
    }

    public void passportCheck() {
        passportChecks.accept(1L);
    }

    public void passportFreq(final int freq) {
        passportFreqStater.accept(
            new RequestInfo(
                freq,
                0,
                0,
                0,
                0L,
                0L));
    }

    public void passportMatch() {
        passportMatches.accept(1L);
    }

    public void passportSkip() {
        passportSkipped.accept(1L);
    }
}

