package ru.yandex.search.shakur;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ShakurConfigBuilder
    extends AbstractShakurConfigBuilder<
        ShakurConfigBuilder>
{
    public ShakurConfigBuilder()
        throws ConfigException
    {
        super(ShakurConfigDefaults.INSTANCE);
    }

    public ShakurConfigBuilder(
        final ShakurConfig config)
        throws ConfigException
    {
        super(config);
    }

    public ShakurConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, ShakurConfigDefaults.INSTANCE);
    }

    public ShakurConfigBuilder(
        final IniConfig config,
        final ShakurConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ShakurConfigBuilder self() {
        return this;
    }

    public ImmutableShakurConfig build()
        throws ConfigException
    {
        return new ImmutableShakurConfig(this);
    }
}
