#!/bin/sh

GB=$((1024*1024*1024))
GB1_5=$((GB + (GB/2)))
GB2=$((GB + GB))
XMX=$(portoctl get . memory_limit_total)
XMX=$((XMX-GB2))

mkdir -p /webcache/javasharedresources/512m >/dev/null 2>&1
export GC_ARGS="-XX:ActiveProcessorCount=6 \
-XX:+IgnoreUnrecognizedVMOptions \
-XcompilationThreads1 \
-Xgc:concurrentScavengeBackground=2 \
-Xgc:concurrentScavenge \
-XX:IdleTuningGcOnIdle \
-XX:IdleTuningMinIdleWaitTime=1 \
-Xgc:maxScavengeBeforeGlobal=100 \
-Xcodecache8M \
-Xcodecachetotal64M \
-Xmso128K \
-Xmcrs64M \
-Xmx$XMX \
-Xms$XMX \
-Xmn1524M \
-Xgcthreads3 \
-Xconcurrentbackground1 \
-Xgc:concurrentMark \
-Xaggressive \
-Xsoftrefthreshold1000000000 \
-Xjit:scratchSpaceLimit=$((64*1024)) \
-Djdk.nio.maxCachedBufferSize=$((256*1024)) \
-verbose:gc \
-Xverbosegclog:/dev/shm/gc.log,10,10000 \
-Xtune:virtualized"