package ru.yandex.peach;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutablePeachQueueConfig implements PeachQueueConfig {
    private final ImmutableHttpTargetConfig backendConfig;
    private final int concurrency;
    private final String deadlineParam;
    private final long retriesIntervalMax;
    private final long retriesIntervalStart;
    private final long rateLimitRetriesIntervalMax;
    private final long rateLimitRetriesIntervalStart;
    private final int batchSize;
    private final long batchMemoryLimit;
    private final boolean parallel;

    public ImmutablePeachQueueConfig(final PeachQueueConfig config)
        throws ConfigException
    {
        backendConfig = new ImmutableHttpTargetConfig(config.backendConfig());
        concurrency = config.concurrency();
        deadlineParam = config.deadlineParam();
        retriesIntervalMax = config.retriesIntervalMax();
        retriesIntervalStart = config.retriesIntervalStart();
        rateLimitRetriesIntervalMax = config.rateLimitRetriesIntervalMax();
        rateLimitRetriesIntervalStart = config.rateLimitRetriesIntervalStart();
        batchSize = config.batchSize();
        batchMemoryLimit = config.batchMemoryLimit();
        parallel = config.parallel();

        if (concurrency <= 0) {
            throw new ConfigException("concurrency is not set");
        }

        if (retriesIntervalMax <= 0L) {
            throw new ConfigException("retries max interval is not set");
        }

        if (retriesIntervalStart <= 0L) {
            throw new ConfigException("retries start interval is not set");
        }

        if (rateLimitRetriesIntervalMax <= 0L) {
            throw new ConfigException(
                "rate limit retries max interval is not set");
        }

        if (rateLimitRetriesIntervalStart <= 0L) {
            throw new ConfigException(
                "rate limit retries start interval is not set");
        }

        if (batchSize <= 0) {
            throw new ConfigException("batch size is not set");
        }
    }

    @Override
    public ImmutableHttpTargetConfig backendConfig() {
        return backendConfig;
    }

    @Override
    public int concurrency() {
        return concurrency;
    }

    @Override
    public String deadlineParam() {
        return deadlineParam;
    }

    @Override
    public long retriesIntervalMax() {
        return retriesIntervalMax;
    }

    @Override
    public long retriesIntervalStart() {
        return retriesIntervalStart;
    }

    @Override
    public long rateLimitRetriesIntervalMax() {
        return rateLimitRetriesIntervalMax;
    }

    @Override
    public long rateLimitRetriesIntervalStart() {
        return rateLimitRetriesIntervalStart;
    }

    @Override
    public int batchSize() {
        return batchSize;
    }

    @Override
    public long batchMemoryLimit() {
        return batchMemoryLimit;
    }

    @Override
    public boolean parallel() {
        return parallel;
    }
}

