package ru.yandex.peach;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class PeachConfigBuilder
    extends AbstractPeachConfigBuilder<PeachConfigBuilder>
{
    public PeachConfigBuilder() {
        super(PeachConfigDefaults.INSTANCE);
    }

    public PeachConfigBuilder(final PeachConfig config) {
        super(config);
    }

    public PeachConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, PeachConfigDefaults.INSTANCE);
    }

    public PeachConfigBuilder(
        final IniConfig config,
        final PeachConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public PeachConfigBuilder self() {
        return this;
    }

    public ImmutablePeachConfig build() throws ConfigException {
        return new ImmutablePeachConfig(this);
    }
}

