package ru.yandex.peach;

import java.util.Collections;
import java.util.Map;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;

public class PeachConfigDefaults
    extends HttpProxyConfigDefaults
    implements PeachConfig
{
    public static final PeachConfigDefaults INSTANCE =
        new PeachConfigDefaults();

    private static final long SHARDS = 65534L;
    private static final long DEFAULT_SHARDS_UPDATE_INTERVAL = 60000L;

    protected PeachConfigDefaults() {
    }

    @Override
    public String name() {
        return "Peach";
    }

    @Override
    public HttpHostConfig searchConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig indexerConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public String searchQueryParams() {
        return "";
    }

    @Override
    public String pkField() {
        return null;
    }

    @Override
    public String pkPrefix() {
        return "";
    }

    @Override
    public String seqField() {
        return null;
    }

    @Override
    public String urlField() {
        return null;
    }

    @Override
    public String queueField() {
        return null;
    }

    @Override
    public String payloadField() {
        return null;
    }

    @Override
    public long shardCount() {
        return SHARDS;
    }

    @Override
    public long shardsUpdateInterval() {
        return DEFAULT_SHARDS_UPDATE_INTERVAL;
    }

    @Override
    public Map<String, PeachQueueConfig> queuesConfig() {
        return Collections.emptyMap();
    }

    @Override
    public Map<Integer, Integer> localPortsMapping() {
        return Collections.emptyMap();
    }
}

