package ru.yandex.peach;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class PeachQueueConfigBuilder
    extends AbstractPeachQueueConfigBuilder<PeachQueueConfigBuilder>
{
    public PeachQueueConfigBuilder() {
        super(PeachQueueConfigDefaults.INSTANCE);
    }

    public PeachQueueConfigBuilder(final PeachQueueConfig config) {
        super(config);
    }

    public PeachQueueConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, PeachQueueConfigDefaults.INSTANCE);
    }

    public PeachQueueConfigBuilder(
        final IniConfig config,
        final PeachQueueConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public PeachQueueConfigBuilder self() {
        return this;
    }

    public ImmutablePeachQueueConfig build() throws ConfigException {
        return new ImmutablePeachQueueConfig(this);
    }
}

