package ru.yandex.peach;

import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigDefaults;

public class PeachQueueConfigDefaults implements PeachQueueConfig {
    public static final PeachQueueConfigDefaults INSTANCE =
        new PeachQueueConfigDefaults();

    private static final long DEFAULT_RETRIES_INTERVAL_MAX = 1000L;
    private static final long DEFAULT_RETRIES_INTERVAL_START = 100L;
    private static final long DEFAULT_RATE_LIMIT_RETRIES_INTERVAL_MAX = 10000L;
    private static final long DEFAULT_RATE_LIMIT_RETRIES_INTERVAL_START = 100L;

    protected PeachQueueConfigDefaults() {
    }

    @Override
    public HttpTargetConfig backendConfig() {
        return HttpTargetConfigDefaults.INSTANCE;
    }

    @Override
    public int concurrency() {
        return 0;
    }

    @Override
    public String deadlineParam() {
        return "deadline";
    }

    @Override
    public long retriesIntervalMax() {
        return DEFAULT_RETRIES_INTERVAL_MAX;
    }

    @Override
    public long retriesIntervalStart() {
        return DEFAULT_RETRIES_INTERVAL_START;
    }

    @Override
    public long rateLimitRetriesIntervalStart() {
        return DEFAULT_RATE_LIMIT_RETRIES_INTERVAL_START;
    }

    @Override
    public long rateLimitRetriesIntervalMax() {
        return DEFAULT_RATE_LIMIT_RETRIES_INTERVAL_MAX;
    }

    @Override
    public int batchSize() {
        return 0;
    }

    @Override
    public long batchMemoryLimit() {
        return 0;
    }

    @Override
    public boolean parallel() {
        return false;
    }
}

