package ru.yandex.peach;

import java.util.Objects;

public class ShardInfo {
    private final long shard;
    private final String queue;

    public ShardInfo(final long shard, final String queue) {
        this.shard = shard;
        this.queue = queue;
    }

    public long shard() {
        return shard;
    }

    public String queue() {
        return queue;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(shard) ^ Objects.hashCode(queue);
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof ShardInfo) {
            ShardInfo other = (ShardInfo) o;
            return shard == other.shard
                && Objects.equals(queue, other.queue);
        }
        return false;
    }
}

