package ru.yandex.peach;

import java.util.List;
import java.util.Map;

import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;
import ru.yandex.search.result.SearchDocument;

public class Task {
    private static final Task[] EMPTY_TASKS = new Task[0];

    private final String pk;
    private final long seq;
    private final String url;
    private final String payload;

    public Task(
        final ImmutablePeachConfig config,
        final Map<String, String> attrs)
        throws JsonUnexpectedTokenException
    {
        pk = ValueUtils.asString(attrs.get(config.pkField()));
        seq = ValueUtils.asLong(attrs.get(config.seqField()));
        url = ValueUtils.asString(attrs.get(config.urlField()));
        payload = ValueUtils.asStringOrNull(attrs.get(config.payloadField()));
    }

    public String pk() {
        return pk;
    }

    public long seq() {
        return seq;
    }

    public String url() {
        return url;
    }

    public String payload() {
        return payload;
    }

    public static Task[] create(
        final List<SearchDocument> hitsArray,
        final ImmutablePeachConfig config)
        throws JsonUnexpectedTokenException
    {
        int size = hitsArray.size();
        if (size == 0) {
            return EMPTY_TASKS;
        }
        Task[] tasks = new Task[size];
        for (int i = 0; i < size; ++i) {
            tasks[i] = new Task(config, hitsArray.get(i).attrs());
        }
        return tasks;
    }
}

