class PostgresDb:

    def __init__(self, pool):
        # self.log = logging.getLogger("backpack")
        # self.log.info("Init postgres")
        self.pool = pool

    async def execute(self, query: str, *args) -> str:
        async with self.pool.acquire() as conn:
            async with conn.transaction():
                resp = await conn.execute(query, *args)
        return resp

    async def fetchval(self, query: str, *args) -> str:
        # print("args is " + str(args))
        async with self.pool.acquire() as conn:
            async with conn.transaction():
                resp = await conn.fetchval(query, *args)
        return resp

    async def fetchrow(self, query: str, *args) -> str:
        # print("args is " + str(args))
        async with self.pool.acquire() as conn:
            async with conn.transaction():
                resp = await conn.fetchrow(query, *args)
        return resp

    async def fetch(self, query: str, *args) -> str:
        # print("args is " + str(args))
        async with self.pool.acquire() as conn:
            async with conn.transaction():
                resp = await conn.fetch(query, *args)
        return resp

    def select(self):
        pass
