from aiohttp import web

from ..misc.exceptions import BackpackAPIServerHardError
from urllib.parse import unquote


class FileInfo:

    def __init__(self, app):
        self.app = app
        self.db = self.app["db"]
        self.log = self.app["alog"]

    async def fileInfo(self, request):
        self.log.info(f'{__name__} called')

        params = request.rel_url.query

        # here how to get query parameters
        version = params['version']
        service = params['service']

        shard = params['shard']
        inum = params['inum']

        # Optional - by version and path like reqest path
        path = params.get('path', False)

        self.log.info(
            f'Getting info request. Version: {version} Service: {service} Shard: {shard} iNum: {inum} Path: {path}')
        infotable = "{}_{}".format(service, version)

        if path:
            self.log.info(
                f'Path param specified filter backup files by version: {version} service: {service} shard: {shard} inum: {inum} path: {unquote(path)}')

            rows = await self.db.fetch(
                '''SELECT * FROM {infotable} WHERE shard = $1 AND inum = $2 AND path LIKE $3 AND stalled != $4'''.format(
                    infotable=infotable),
                (int(shard)),
                (int(inum)),
                (f'{unquote(path)}%'),
                True
            )
        else:
            self.log.info(
                f'Path doesnot specified filter backup files by version: {version} service: {service} shard: {shard} inum: {inum}')

            rows = await self.db.fetch(
                '''SELECT * FROM {infotable} WHERE shard = $1 AND inum = $2 AND stalled != $3'''.format(infotable=infotable),
                (int(shard)),
                (int(inum)),
                True
            )

        # TODO: if status doesnot finished and size !=0 - do not allow to restore backuo?

        # erows = await db.fetch('''SELECT * FROM {infotable} WHERE shard = $1 AND inum = $2 AND status != $3'''.format(infotable=infotable),
        #                        (int(shard)),
        #                        (int(inum)),
        #                        ("FINISHED")
        #                      )
        #
        # if len(erows) != 0:
        #     raise BackpackAPIServerHardError(f'Error rows for version {version} and shard {shard} founded. Backup uncompleted!')

        if len(rows) == 0:
            raise BackpackAPIServerHardError("Files info not found")

        filesinfo = []
        for row in rows:
            filesinfo.append(dict(row))

        return web.json_response(filesinfo)
