from aiohttp import web

from ..misc.exceptions import BackpackAPIServerHardError


class FileInfoUpdate:

    def __init__(self, app):
        self.app = app
        self.db = self.app["db"]
        self.log = self.app["alog"]

    async def fileInfoUpdate(self, request):
        self.log.info(f'{__name__} called')

        rq = await request.json()
        infotable = "{}_{}".format(rq['service'], rq['version'])

        # self.log.info(f"Request: {rq}")

        row = await self.db.fetch(
            '''SELECT * FROM {infotable} WHERE path = $1 AND hostname = $2'''.format(infotable=infotable),
            (rq['path']),
            (rq['hostname'])
            )
        if len(row) == 0:
            raise BackpackAPIServerHardError("File info not found")

        if row[0]['fsize'] != int(rq['fsize']):
            # we do not update size info because error may reached and size will be then
            self.log.warning("Size mismatch! path: {} metavalue: {} newvalue: {}".format(rq['path'],
                                                                                         str(row[0]['fsize']),
                                                                                         str(rq['fsize'])
                                                                                         ))
            # raise BackpackAPIServerHardError("Size mismatch! path: {} metavalue: {} newvalue: {}"
            #                                  .format(rq['path'],
            #                                          str(row[0]['fsize']),
            #                                          str(rq['fsize'])
            #                                          ))

        if row[0]['md5'] != rq['md5']:
            self.log.warning("Md5 mismatch! path: {} metavalue: {} newvalue: {}".format(rq['path'],
                                                                                        row[0]['md5'],
                                                                                        rq['md5']))
            # raise BackpackAPIServerHardError("Md5 mismatch! path: {} metavalue: {} newvalue: {}".format(rq['path'],
            #                                                                                             row[0]['md5'],
            #                                                                                             rq['md5']))

        if len(row) > 1:
            self.log.warning("More then one keys found. Table: {} Keys: {}".format(infotable, "path, host, mdskey"))

        # Do not update another mdskeys if they exists? Update only by none?
        # if md5 if differs - client cannot store that file if it set up
        rq = await self.db.execute('''
            UPDATE {infotable} SET msg=$1, status=$2, mdskey=$3 WHERE path = $4 AND hostname = $5'''.format(
            infotable=infotable),
            (rq['msg']),
            (rq['status']),
            (rq['mdskey']),
            (rq['path']),
            (rq['hostname']))

        self.log.info("Update status: " + str(rq))

        # {'path': "/webcache/dsearch/iNum:1/index/59/_8w_1.del",
        # "msg": "success",
        # "mdskey": "65915/12312312321312:/webcache/dsearch/iNum:1/index/59/_8w_1.del",
        # "status": "FINISHED",
        # "md5": "RJrzm4oRKeq35mwkjU3aCA==",
        # "fsize": "79",
        # "shard":"59",
        # "inum":"1",
        # "hostname":"sas1-123.search.yandex.net",
        # "version": "12312312321312",
        # "service": "disk_search_backend_test"}

        return web.Response(text="OK", status=200)
