import asyncpg

from aiohttp import web

# from ..misc.exceptions import BackpackAPIServerHardError


class FileRestoreInfoUpdate:

    def __init__(self, app):
        self.app = app
        self.db = self.app["db"]
        self.log = self.app["alog"]

    async def fileRestoreInfoUpdate(self, request):
        self.log.info(f'{__name__} called')

        rq = await request.json()
        self.log.info(f"Request: {rq}")

        # shard = rq['shard']
        # inum = rq['inum']
        # hostname = rq['hostname']
        path = rq['path']
        r_infotable = "{}_{}_restored".format(rq['service'], rq['version'])

        self.log.info("path is: {}".format(path))

        try:
            # we need set stalled on another action (or drop)
            # stalled = await self.db.execute(
            #     '''UPDATE {r_infotable} SET stalled = $1 WHERE shard = $2 AND inum = $3 AND hostname = $4'''.format(
            #         r_infotable=r_infotable),
            #     True,
            #     (int(shard)),
            #     (int(inum)),
            #     (hostname)
            # )
            # self.log.info(
            #     f"Set stalled for shard, all old files for all hosts: {shard} table: {r_infotable}. Stalled: {stalled}")

            f_id = await self.initfileinfo(r_infotable, path, rq)
        except asyncpg.exceptions.UndefinedTableError:

            # Uniq keys for init table

            self.log.info("Table  for files {} doesnot exist, creating.".format(r_infotable))

            await self.db.execute('''
                 CREATE TABLE {r_infotable}(
                 f_id bigserial not null primary key,
                 path varchar(5000) not null,
                 rootpath varchar(5000) not null,
                 msg varchar(2000) not null,
                 mdskey varchar(5000) not null,
                 status varchar(200) not null,
                 md5 varchar(200),
                 fsize bigint not null,
                 shard integer not null,
                 numdocs integer not null,
                 inum integer not null,
                 hostname varchar(1000) not null,
                 stalled boolean default false not null,
                 UNIQUE (path, md5, hostname)
                 )
             '''.format(r_infotable=r_infotable))

            f_id = await self.initfileinfo(r_infotable, path, rq)

        self.log.info("File backup id is: {}".format(f_id))

        return web.Response(text="OK", status=200)

    async def initfileinfo(self, r_infotable, path, rq):
        try:
            f_id = await self.db.fetchval(
                '''INSERT INTO {r_infotable}(path, rootpath, msg, mdskey, status, md5, fsize, shard, numdocs, inum, hostname)
                VALUES($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11) ON CONFLICT (path, md5, hostname) DO UPDATE SET status = $5 RETURNING f_id'''.format(r_infotable=r_infotable),
                (path),
                (rq['rootpath']),
                (rq['msg']),
                (rq['mdskey']),
                (rq['status']),
                (rq['md5']),
                (int(rq['fsize'])),
                (int(rq['shard'])),
                0,
                (int(rq['inum'])),
                (rq['hostname'])
            )
        except asyncpg.exceptions.UniqueViolationError:
            self.log.warning("Table init pass. This records was already initialized: {} {} {}".format(path,
                                                                                                      rq['md5'],
                                                                                                      rq['hostname']
                                                                                                      ))
            f_id = "none"
        return f_id
