from aiohttp import web

from ..misc.defaults import STATUS_FINISHED, STATUS_PENDING,  STATUS_PASSED,  STATUS_ERROR, STATUS_UNKNOWN, STATUS_STALLED


class ServiceBackupInfo:

    def __init__(self, app):
        self.app = app
        self.db = self.app["db"]
        self.log = self.app["alog"]

    async def backupInfo(self, request):
        self.log.info(f'{__name__} called')

        # params = request.rel_url.query

        rows_services = await self.db.fetch(
            '''SELECT * FROM {s_table}'''.format(s_table="services"))

        service_status_d = {}
        infotable_checked = set()
        for row_s in rows_services:
            service = row_s['service']

            if not service_status_d.get(service):
                service_status_d[service] = {}

            service_status_d[service][STATUS_FINISHED] = 0
            service_status_d[service][STATUS_PENDING] = 0
            service_status_d[service][STATUS_ERROR] = 0

            rows_services_meta = await self.db.fetch(
                '''SELECT * FROM services_meta WHERE service_id=$1''', row_s['s_id'])

            for row_m in rows_services_meta:
                version = row_m["version"]

                tbl = f"{service}_{version}"

                if tbl not in infotable_checked:
                    infotable_checked.add(tbl)
                    rows_info = await self.db.fetch(
                        '''SELECT status FROM {infotable}'''.format(infotable=tbl)
                    )

                    stat_dict = {"status": STATUS_UNKNOWN,
                                 STATUS_FINISHED: [],
                                 STATUS_ERROR: [],
                                 STATUS_PASSED: [],
                                 STATUS_PENDING: [],
                                 STATUS_STALLED: []}

                    for row_i in rows_info:
                        if (dict(row_i))['stalled']:
                            stat_dict[STATUS_STALLED].append(dict(row_i))
                            continue
                        if (dict(row_i))['status'] == STATUS_FINISHED:
                            stat_dict[STATUS_FINISHED].append(dict(row_i))
                        if (dict(row_i))['status'] == STATUS_ERROR:
                            stat_dict[STATUS_ERROR].append(dict(row_i))
                        if (dict(row_i))['status'] == STATUS_PASSED:
                            stat_dict[STATUS_PASSED].append(dict(row_i))
                        if (dict(row_i))['status'] == STATUS_PENDING:
                            stat_dict[STATUS_PENDING].append(dict(row_i))

                    if len(stat_dict[STATUS_ERROR]) != 0:
                        stat_dict["status"] = STATUS_ERROR
                        service_status_d[service][STATUS_ERROR] += 1
                    elif len(stat_dict[STATUS_PENDING]) != 0:
                        stat_dict["status"] = STATUS_PENDING
                        service_status_d[service][STATUS_PENDING] += 1
                    elif (len(stat_dict[STATUS_FINISHED]) != 0) or (len(stat_dict[STATUS_PASSED]) != 0):
                        stat_dict["status"] = STATUS_FINISHED
                        service_status_d[service][STATUS_FINISHED] += 1

            # answer_json = {"rows": list(rows_services),
            #                "state": service_status_d}
            # print(answer_json)
        return web.json_response({"state": service_status_d})
