from aiohttp import web

# from ..misc.exceptions import BackpackAPIServerHardError
from asyncpg import UndefinedTableError
# from ..misc.exceptions import BackpackAPIServerHardError
from ..misc.defaults import STATUS_FINISHED, STATUS_PENDING,  STATUS_PASSED,  STATUS_ERROR, STATUS_UNKNOWN, STATUS_STALLED, STATUS_NOTINITIALIZED


class ShardBackupInfo:

    def __init__(self, app):
        self.app = app
        self.db = self.app["db"]
        self.log = self.app["alog"]

    async def backupInfo(self, request):
        self.log.info(f'{__name__} called')

        params = request.rel_url.query

        # here how to get query parameters
        version = params['version']
        service = params['service']
        shard = params['shard']
        inum = params['inum']

        self.log.info(
            f'Getting info request. Version: {version} Service: {service} Shard: {shard} iNum: {inum}')

        infotable = "{}_{}".format(service, version)
        try:
            rows = await self.db.fetch(
                '''SELECT * FROM {infotable} WHERE shard = $1 AND inum = $2'''.format(infotable=infotable),
                (int(shard)),
                (int(inum))
            )
        except UndefinedTableError:
            self.log.error(f"Backup table wasn't initializated {infotable}")
            # raise BackpackAPIServerHardError(f"Backup table wasn't initializated {infotable}")
            answer_json = {"status": STATUS_NOTINITIALIZED,
                           "info": []}
            return web.json_response(answer_json)

        answer_json = {"status": STATUS_UNKNOWN,
                       STATUS_FINISHED: [],
                       STATUS_ERROR: [],
                       STATUS_PASSED: [],
                       STATUS_PENDING: [],
                       STATUS_STALLED: []}

        for row in rows:
            if (dict(row))['stalled']:
                answer_json[STATUS_STALLED].append(dict(row))
                continue
            if (dict(row))['status'] == STATUS_FINISHED:
                answer_json[STATUS_FINISHED].append(dict(row))
            if (dict(row))['status'] == STATUS_ERROR:
                answer_json[STATUS_ERROR].append(dict(row))
            if (dict(row))['status'] == STATUS_PASSED:
                answer_json[STATUS_PASSED].append(dict(row))
            if (dict(row))['status'] == STATUS_PENDING:
                answer_json[STATUS_PENDING].append(dict(row))

        if len(answer_json[STATUS_ERROR]) != 0:
            answer_json["status"] = STATUS_ERROR
        elif len(answer_json[STATUS_PENDING]) != 0:
            answer_json["status"] = STATUS_PENDING
        elif (len(answer_json[STATUS_FINISHED]) != 0) or (len(answer_json[STATUS_PASSED]) != 0):
            answer_json["status"] = STATUS_FINISHED

        return web.json_response(answer_json)
