import os
import time

from aiohttp import web

from ..misc.defaults import STATUS_WORKER_NOT_STARTED, STATUS_WORKER_FINISHED
from ..misc.exceptions import BackpackAPIServerHardError


class SlotAdd:

    def __init__(self, app):
        self.app = app
        self.db = self.app["db"]
        self.log = self.app["alog"]

    async def request(self, request):
        self.log.info(f'{__name__} called')
        params = request.rel_url.query

        config = params['config']
        times = int(time.time())

        CONF_PATH="worker/configs/"

        conf_files = set(f for f in os.listdir(f"{CONF_PATH}") if f.endswith('.conf') if f != "default.conf")

        if config not in conf_files:
            raise BackpackAPIServerHardError(f"Config must in set: {conf_files}")

        # Check running jobs for this config
        act_rows = await self.db.fetchrow(
            '''SELECT * FROM slots WHERE config = $1 AND status != $2''',
            config,
            STATUS_WORKER_FINISHED
        )

        print(act_rows)

        if act_rows:
            raise BackpackAPIServerHardError(f"Finding active job for this config, cannot add another: {act_rows}")

        # Insert new slot
        rows = await self.db.fetch(
            '''INSERT INTO slots(times, status, config) VALUES($1, $2, $3) RETURNING *''',
            times,
            STATUS_WORKER_NOT_STARTED,
            config
        )

        print(rows)

        return web.json_response({"status": "DONE",
                                  "info": dict(rows[0])}
                                 )
