from aiohttp import web

from ..misc.exceptions import BackpackAPIServerHardError
from ..misc.defaults import STATUS_WORKER_STARTED, STATUS_WORKER_NOT_STARTED, STATUS_WORKER_FINISHED


class SlotRequest:

    def __init__(self, app):
        self.app = app
        self.db = self.app["db"]
        self.log = self.app["alog"]

    async def request(self, request):
        self.log.info(f'{__name__} called')

        params = request.rel_url.query

        # here how to get query parameters
        # One worker per hostname
        hostname = params['hostname']
        times = int(params['timestamp'])
        version = int(params['version'])

        self.log.info(
            f'Getting slot request. Hostname: {hostname}')

        # Check thar worker already have a job
        rows_check = await self.db.fetch(
            '''SELECT * FROM slots WHERE hostname =$1 AND NOT status=$2''',
            hostname,
            STATUS_WORKER_FINISHED
        )

        if len(rows_check) != 0:
            if len(rows_check) > 1:
                self.log.info(f"Too many workers for host: {hostname} already have a job(s) {rows_check}")
                raise BackpackAPIServerHardError(f"Too many workers for. Host already have a job! hostname: {hostname} "
                                                 f"jobs: {rows_check}")

            # TODO: Worker must continue backup if backup doesnot finished?
            self.log.info(f"Worker from this host: {hostname} already have a job(s) {rows_check}")
            data = dict(rows_check[0])
            return web.json_response({"status": data["status"],
                                      "info": data}
                                     )
            # raise BackpackAPIServerHardError(f"Worker already have a job! hostname: {hostname} jobs: {rows_check}")

        rows = await self.db.fetch(
            '''UPDATE slots SET hostname=$1, status=$2, times=$3, version=$4 WHERE id in (
                        SELECT id FROM slots WHERE hostname is NULL AND status=$5 LIMIT 1) RETURNING *''',
            hostname,
            STATUS_WORKER_STARTED,
            (int(times)),
            version,
            STATUS_WORKER_NOT_STARTED
        )

        if len(rows) == 0:
            self.log.info("No jobs for workers")
            return web.json_response({"status": "TRY_LATER",
                                      "info": {}})

        print(rows)
        print(dict(rows[0]))

        return web.json_response({"status": "LOCK_ACQUIRED",
                                  "info": dict(rows[0])}
                                 )
