from aiohttp import web
from ..misc.exceptions import BackpackAPIServerHardError
# from ..misc.defaults import STATUS_WORKER_STARTED, STATUS_WORKER_NOT_STARTED, STATUS_WORKER_FINISHED, \
#     STATUS_WORKER_PENDING


class SlotUpdate:

    def __init__(self, app):
        self.app = app
        self.db = self.app["db"]
        self.log = self.app["alog"]

    async def request(self, request):
        self.log.info(f'{__name__} called')
        params = request.rel_url.query

        # three actions - set perc, increment perc, set status

        action = params['action']
        hostname = params['hostname']
        times = int(params['timestamp'])
        version = int(params['version'])

        if action == "set_perc":
            percent = float(params['percent'])
            rows = await self.db.fetch(
                '''UPDATE slots SET percent=$1, times=$2 WHERE hostname =$3 AND version=$4 RETURNING *''',
                percent,
                times,
                hostname,
                version
            )
        elif action == "increment_perc":
            percent = float(params['percent'])
            rows = await self.db.fetch(
                '''UPDATE slots SET percent=percent + $1, times=$2 WHERE hostname =$3 AND version=$4 RETURNING *''',
                percent,
                times,
                hostname,
                version
            )
        elif action == "set_status":
            status = params['status']
            rows = await self.db.fetch(
                '''UPDATE slots SET status=$1,times=$2 WHERE hostname =$3 AND version=$4 RETURNING *''',
                status,
                times,
                hostname,
                version
            )
        else:
            raise BackpackAPIServerHardError(f"Action param doesnot set! {hostname} {version} ")

        if len(rows) == 0:
            info = {}
        else:
            info = dict(rows[0])

        return web.json_response({"status": "DONE",
                                  "info": info}
                                 )
