import aiohttp_jinja2
from aiohttp import web

# from ...misc.defaults import STATUS_UNKNOWN, STATUS_FINISHED, STATUS_ERROR, STATUS_PASSED, STATUS_PENDING


class ServiceBackupInumView(web.View):

    @aiohttp_jinja2.template('backup_inum_tmpl.jinja2')
    async def get(self):
        db = self.request.app['db']
        service = self.request.match_info['service_name']
        version = self.request.match_info['version']

        infotable = "{}_{}".format(service, version)

        f_rows = await db.fetch('''SELECT * FROM {infotable}'''.format(infotable=infotable))

        inumdata = {}
        # stat_dict = {}

        for row in f_rows:
            if row['inum'] in inumdata:
                inumdata[row['inum']]['numdocs'] = inumdata[row['inum']]['numdocs'] + row['numdocs']
                # inumdata[row['inum']][row['status']] += 1
            else:
                inumdata[row['inum']] = {}
                # inumdata[row['inum']][STATUS_FINISHED] = 0
                # inumdata[row['inum']][STATUS_ERROR] = 0
                # inumdata[row['inum']][STATUS_PASSED] = 0
                # inumdata[row['inum']][STATUS_PENDING] = 0
                inumdata[row['inum']]['numdocs'] = row['numdocs']
                # inumdata[row['inum']][row['status']] += 1

        # for inum, data in inumdata.items():
        #     stat_dict[inum] = {}
        #     if data[STATUS_ERROR] != 0:
        #         stat_dict[inum] = STATUS_ERROR
        #     elif data[STATUS_PENDING] != 0:
        #         stat_dict[inum]= STATUS_PENDING
        #     elif (data[STATUS_FINISHED] != 0) or (data[STATUS_PASSED] != 0):
        #         stat_dict[inum] = STATUS_FINISHED

        # return {"inumdata": inumdata,
        #         "service": service,
        #         "version": version,
        #         "state": stat_dict}

        return {"inumdata": inumdata,
                "service": service,
                "version": version}
