import aiohttp_jinja2
from aiohttp import web


class ServiceBackupShardDetailView(web.View):
    @aiohttp_jinja2.template('backup_shard_detail_tmpl.jinja2')
    async def get(self):
        db = self.request.app['db']
        service = self.request.match_info['service_name']
        version = self.request.match_info['version']
        inum = self.request.match_info['inum']
        shard = self.request.match_info['shard']

        infotable = "{}_{}".format(service, version)

        f_rows = await db.fetch('''SELECT * FROM {infotable} WHERE inum = $1 AND shard = $2'''.format(infotable=infotable),
                                (int(inum)),
                                (int(shard)))

        return {"rows": f_rows,
                "service": service,
                "version": version}
