import aiohttp_jinja2
from aiohttp import web

from ...misc.defaults import STATUS_FINISHED, STATUS_ERROR, STATUS_PASSED, STATUS_PENDING


class ServiceBackupShardView(web.View):
    @aiohttp_jinja2.template('backup_shard_tmpl.jinja2')
    async def get(self):
        db = self.request.app['db']
        service = self.request.match_info['service_name']
        version = self.request.match_info['version']
        inum = self.request.match_info['inum']

        infotable = "{}_{}".format(service, version)

        f_rows = await db.fetch('''SELECT * FROM {infotable} WHERE inum = $1'''.format(infotable=infotable),
                                (int(inum)))

        sharddata = {}
        # stat_dict = {}

        for row in f_rows:
            if row['shard'] in sharddata:
                sharddata[row['shard']][row['status']] += 1
        #        inumdata[row['shard']]['numdocs'] = inumdata[row['inum']]['numdocs'] + row['numdocs'];
            else:
                sharddata[row['shard']] = {}
                sharddata[row['shard']]['numdocs'] = row['numdocs']
                sharddata[row['shard']][STATUS_FINISHED] = 0
                sharddata[row['shard']][STATUS_ERROR] = 0
                sharddata[row['shard']][STATUS_PASSED] = 0
                sharddata[row['shard']][STATUS_PENDING] = 0

        # for shard, data in sharddata.items():
        #     stat_dict[shard] = {}
        #     if data[STATUS_ERROR] != 0:
        #         stat_dict[shard] = STATUS_ERROR
        #     elif data[STATUS_PENDING] != 0:
        #         stat_dict[shard] = STATUS_PENDING
        #     elif (data[STATUS_FINISHED] != 0) or (data[STATUS_PASSED] != 0):
        #         stat_dict[shard] = STATUS_FINISHED

        # print(f"ROWS {f_rows}")

        return {"sharddata": sharddata,
                "service": service,
                "version": version,
                "inum": inum}
